#ifndef __CMidiViz__
#define __CMidiViz__

//	===========================================================================

#include <audioeffectx.h>
#include <ECore.h>
#include <EMusic.h>
#include <EGUI.h>
#include <EVST.h>

//	===========================================================================

/**
 * @namespace Exponent
 * @brief Main Exponent namespace
 */
namespace Exponent
{
	/**
	 * @namespace MidiViz
	 * @brief MidiViz namespace
	 */
	namespace MidiViz
	{
		/**
		 * @class CMidiViz CMidiViz.hpp
		 * @brief Midi Viz vst class
		 *
		 * @date 28/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 *
		 * $Id: CMidiViz.hpp,v 1.8 2007/02/27 19:48:10 paul Exp $
		 */
		class CMidiViz : public CVstEffect
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */


//	===========================================================================

		public:

//	===========================================================================

			/**
			 * @enum EEventVisibility
			 * @brief Show which events
			 */
			enum EEventVisibility
			{
				e_allEvents = 0,							/**< Show all events */
				e_notesOnly,								/**< Show notes only */
				e_ccOnly,									/**< Show cc only */
				e_notesAndCCOnly,							/**< SHow notes and cc only */
				e_otherOnly,								/**< Only other types of message */
			};

//	===========================================================================

			/**
			 * Construction
			 * @param audioMaster The audio master call back function
			 */
			CMidiViz(audioMasterCallback audioMaster);

			/**
			 * Destruction
			 */
			~CMidiViz();

//	===========================================================================

			/**
			 * Process
			 * @param input The input audio buffers
			 * @param output The output audio buffer
			 * @param numberOfSamples The number of samples to process
			 */
			#ifdef VST_2_4_EXTENSIONS
			virtual void process(float **input, float **output, VstInt32 numberOfSamples);
			#else
			virtual void process(float **input, float **output, long numberOfSamples);
			#endif

			/**
			 * Process Replacing
			 * @param output The output audio buffer
			 * @param numberOfSamples The number of samples to process
			 */
			#ifdef VST_2_4_EXTENSIONS
			virtual void processReplacing(float **input, float **output, VstInt32 numberOfSamples);
			#else
			virtual void processReplacing(float **input, float **output, long numberOfSamples);
			#endif

			/**
			 * Process VST midi events
			 * @param events the midi events
			 * @retval VstInt32 0 for more, undefined otherwise
			 */
			#ifdef VST_2_4_EXTENSIONS
			virtual VstInt32 processEvents(VstEvents *events);
			#else
			virtual long processEvents(VstEvents *events);
			#endif

//	===========================================================================

			/**
			 * What can this plugin do
			 * @param text the opcode string as defined in the VSTSDK
			 * @retval -1 cant do, 0, dont know, 1 can do
			 * @see CVst
			 */
			#ifdef VST_2_4_EXTENSIONS
			virtual VstInt32 canDo(char *text);
			#else 
			virtual long canDo(char* text);
			#endif

			// Get the output pin properties
			#ifdef VST_2_4_EXTENSIONS
			virtual bool getOutputProperties(VstInt32 index, VstPinProperties* properties);
			#else
			virtual bool getOutputProperties(long index, VstPinProperties* properties);
			#endif

			// Get the input pin properties
			#ifdef VST_2_4_EXTENSIONS
			virtual bool getInputProperties(VstInt32 index, VstPinProperties *properties);
			#else
			virtual bool getInputProperties(long index, VstPinProperties *properties);
			#endif

//	===========================================================================

			/**
			 * Open the stream
			 * @param filename The name of the file
			 */
			void openStream(const CSystemString &filename);

			/**
			 * Close the stream
			 */
			void closeStream();

			/**
			 * Set the visibility
			 * @param visibility The event visibility
			 */
			void setVisibility(const EEventVisibility visibility) { m_visibility = visibility; }

//	===========================================================================

		protected:

//	===========================================================================

			CTextStream m_outputStream;				/**< The output stream */
			EEventVisibility m_visibility;			/**< Event visibility */
		};
	}
}
#endif
